//importerer ulike funskjoner fra firebase
import { initializeApp } from "https://www.gstatic.com/firebasejs/10.8.1/firebase-app.js";
import { getAnalytics } from "https://www.gstatic.com/firebasejs/10.8.1/firebase-analytics.js";
import { getFirestore, query, collection, getDoc, getDocs, doc, addDoc, updateDoc, deleteDoc, onSnapshot, orderBy, where, limit } from "https://www.gstatic.com/firebasejs/10.8.1/firebase-firestore.js";

//Firebase konfigurasjon
const firebaseConfig = {
    apiKey: "AIzaSyDJFkwypluT2Vm_EH4_T57sCcJflFdavjA",
    authDomain: "klassefest-123.firebaseapp.com",
    projectId: "klassefest-123",
    storageBucket: "klassefest-123.appspot.com",
    messagingSenderId: "782442822695",
    appId: "1:782442822695:web:3704393e016d9d81426202",
    measurementId: "G-QB3XJCZZDJ"
};

// Starter opp firebase, og lager variabler som vi kan bruke videre i koden.
const app = initializeApp(firebaseConfig);
const db = getFirestore(app);
const q = query(collection(db, "klassefest"));

//Denne funksjonen legger til en ny elev i databasen vår, sammen med dems informasjon.
//Grunnet til at module ikke ville funke for oss, måtte vi bruke export for å kunne gjøre denne funksjonen tilgjengelig for vår html. Og ikke bare javascripten alene.
export async function leggTilElev(elevNavn, elevKlasse) {
    console.log(elevNavn, elevKlasse);
    
    //Ved å bruke try og catch så håndterer vi ulike feilkoder så programmet ikke kræsjer eller gir ut sensitiv informasjon. 
    try {
        const idNummer = Math.floor(Math.random() * 9000) + 1000; // Genererer et unikt ID nummer med 4 siffere til hver elev.
        await addDoc(collection(db, "klassefest"), {
            ID: idNummer,
            Navn: elevNavn,
            Klasse: elevKlasse
        });

        // Gjemmer overlayen og skjemaet når vi legger til en ny elev
        document.getElementById('formOverlay').style.display = 'none';
        document.querySelector('.form').style.display = 'none';

    } catch (e) {
        console.error("Kunne ikke legge til dokument.", e);
    }
}

export async function visElever() {
    try {
        const klasseTabell = document.getElementById('klasse-tabell');

        klasseTabell.querySelectorAll('tr:not(:first-child)').forEach(row => row.remove()); // Sletter rows som allerede er der for å kunne oppdatere.

        const querySnapshot = await getDocs(q);

        querySnapshot.forEach((doc) => {
            const elevData = doc.data();
            const row = document.createElement('tr');

            row.innerHTML = `
                <td>${elevData.ID}</td>
                <td>${elevData.Navn}</td>
                <td>${elevData.Klasse}</td>
                <td>
                    <button class="slettKnapp" data-id="${doc.id}">Slett</button>
                </td>
            `;

            klasseTabell.appendChild(row);
        });
    } catch (e) {
        console.log("Kunne ikke hente ut elevene.", e);
    }
}

export async function slettElev(elevId) {
    try {
        await deleteDoc(doc(db, "klassefest", elevId));
        console.log("Dokument slettet!");
    } catch (e) {
        console.error("Problemer med å slette dokument: ", e);
    }
}

//Sjekker om HTML er Loadet.
document.addEventListener('DOMContentLoaded', async () => {

    // Legg til event listener for å legge til elev
    document.querySelector('.form-btn').addEventListener('click', async () => {
        const elevNavn = document.getElementById('navnInput').value;
        const elevKlasse = document.getElementById('klasseInput').value;
        await leggTilElev(elevNavn, elevKlasse);
    });

    
    document.getElementById('klasse-tabell').addEventListener('click', async (event) => {
        if (event.target && event.target.classList.contains('slettKnapp')) { //sjekker for museklikk i klassetabell, om det vi trykker på er en slett knapp
            const elevId = event.target.getAttribute('data-id');
            await slettElev(elevId);
        }
    });

    //Oppdaterer siden live
    onSnapshot(q, async (snapshot) => {
        await visElever();
    });
});
